﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityStandardAssets.Characters.ThirdPerson;
using GameUtility;

//	Summary
//		* Player를 제어한다.

namespace Game
{
	/*
		Player 제어 관리자.
	*/
	public class PlayerController : MonoBehaviour
	{

		public PlayerState PS;
		public SimpleCharacterControl Character;

		public int RecoveryValue	= 10;
		public int DamageValue = 50;

		public AudioClip m_PainSound;
		public AudioClip m_KilledSound;

		PlayerHealth m_PlayerHealth;

		Rigidbody m_RigidBody;

		BottomType m_CurrentBottomType;

		// Use this for initialization
		void Start ()
		{
			PS = PlayerState.Default;

			m_PlayerHealth	= GetComponent<PlayerHealth> ();

			PlayerMovement.onPlayerTrigger += onPlayerTrigger;
			PlayerMovement.onPlayerLanding += onPlayerLanding;

			// m_RigidBody.WakeUp();

		}
	
		// Update is called once per frame
		void Update ()
		{
		
			// if (PS == PlayerState.Move) {
			// 	m_RigidBody.WakeUp();
			// }
		}

		void OnDestroy ()
		{
			PlayerMovement.onPlayerTrigger	-= onPlayerTrigger;
			PlayerMovement.onPlayerLanding	-= onPlayerLanding;
		}

		// MARK: - Delegate
		void onPlayerTrigger (GameObject obj)
		{
			// Debug.Log(other.gameObject.tag);
			if (PS != PlayerState.Death) {
				if (obj.tag == "DeadZoneTop"
				   || obj.tag == "DeadZone") {
					Death ();
				}
			} else {
				// Move();
			}
		}

		void onPlayerLanding (GameObject obj)
		{
			if (obj == null) {
				m_CurrentBottomType	= BottomType.None;
				return;
			}

			if (obj.tag == "Bottom") {

				BottomItem item = obj.GetComponent<BottomItem> ();

				if (item.DidEvent == false) {
					item.DidEvent	= true;

					Character.GetComponent<FootStep> ().Landing ();

					BottomType type = item.GetBottomType ();

					switch (type) {
					case BottomType.Normal:
					case BottomType.Disappear:
					case BottomType.SlideLeft:
					case BottomType.SlideRight:
						m_PlayerHealth.TakeRecovery (RecoveryValue);
						break;
					case BottomType.Damage:
						m_PlayerHealth.TakeDamage (DamageValue);
						onPlayPainSound ();
						break;
					default:
						break;
					}
				}

				m_CurrentBottomType	= item.GetBottomType ();
			}
		}

		// MARK: - Public
		/*
			Player가 위치한 bottom type을 반환한다.

			@return BottomType
	 	*/
		public BottomType GetCurrentBottomType ()
		{
			return m_CurrentBottomType;
		}

		/*
			Player가 위치한 bottom type을 설정한다.

			@param type BottomType
	 	*/
		public void SetCurrentBottomType (BottomType type)
		{
			m_CurrentBottomType = type;
		}

		/*
			Player death.
	 	*/
		public void Death ()
		{
			PS	= PlayerState.Death;

			m_PlayerHealth.TakeDamage (int.MaxValue);

			onPlayKilledSound ();
		}


		// MARK: - Private
		/*
			Player가 피격시 sound를 재생한다.
	 	*/
		void onPlayPainSound ()
		{
			AudioSource source = GetComponent<AudioSource> ();

			if (source != null && m_PainSound != null) {
				source.PlayOneShot (m_PainSound);
			}
		}

		/*
			Player가 사망시 sound를 재생한다.
	 	*/
		void onPlayKilledSound ()
		{
			AudioSource source = GetComponent<AudioSource> ();

			if (source != null && m_KilledSound != null) {
				source.PlayOneShot (m_KilledSound);
			}
		}
	}
}
